/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.query.core.DataSource1;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.LogFactory;

public class DataSourceNamedGroup
implements DataSource {
    public boolean trustedGraphs = false;
    static final String baseURI = "urn:x-arq:model:";
    static int labelCounter = 0;
    Map namedSources = new HashMap();
    MultiUnion unionGraph = new MultiUnion();
    Model unionModel = ModelFactory.createModelForGraph((Graph)this.unionGraph);
    Model defaultModel = ModelFactory.createDefaultModel();

    public DataSourceNamedGroup() {
        this(false);
    }

    public DataSourceNamedGroup(boolean bl) {
        this.trustedGraphs = bl;
        this.unionGraph.addGraph(this.defaultModel.getGraph());
        this.unionGraph.setBaseGraph(this.defaultModel.getGraph());
    }

    public DataSource getDataSource(String string) {
        Object v = this.namedSources.get(string);
        return (DataSource)v;
    }

    public void addDataSource(String string, DataSource dataSource) {
        if (this.namedSources.containsKey(string)) {
            throw new LabelExistsException("Label: " + string);
        }
        this.namedSources.put(string, dataSource);
        if (this.trustedGraphs) {
            this.unionGraph.addGraph(dataSource.getGraph());
        }
    }

    public void addModel(Model model) {
        this.addModel(DataSourceNamedGroup.nextURI(), model);
    }

    public void addModel(String string, Model model) {
        DataSource1 dataSource1 = new DataSource1(model);
        this.addDataSource(string, dataSource1);
    }

    public void removeDataSource(String string) {
        if (!this.namedSources.containsKey(string)) {
            throw new NoSuchElementException(DataSourceNamedGroup.class.getName());
        }
        Model model = (Model)this.namedSources.get(string);
        this.namedSources.remove(string);
        this.unionGraph.removeGraph(model.getGraph());
    }

    public void removeModel(String string) {
        this.removeDataSource(string);
    }

    public void replaceModel(String string, Model model) {
        this.removeDataSource(string);
        this.addModel(string, model);
    }

    public void replaceDataSource(String string, DataSource dataSource) {
        this.removeDataSource(string);
        this.addDataSource(string, dataSource);
    }

    public Iterator listModelLabels() {
        return this.namedSources.keySet().iterator();
    }

    public Iterator listDataSources() {
        return this.namedSources.values().iterator();
    }

    public Model getModel(String string) {
        DataSource dataSource = (DataSource)this.namedSources.get(string);
        if (dataSource == null) {
            return null;
        }
        return dataSource.getModel();
    }

    public Model getModel() {
        return this.unionModel;
    }

    public Graph getGraph() {
        return this.unionGraph;
    }

    public boolean isAggregate() {
        return true;
    }

    public void close() {
        Iterator iterator = this.namedSources.values().iterator();
        while (iterator.hasNext()) {
            DataSource dataSource = (DataSource)iterator.next();
            if (dataSource == this) {
                LogFactory.getLog((Class)DataSourceNamedGroup.class).warn((Object)"Data source registered with itself.");
                return;
            }
            dataSource.close();
        }
        this.unionModel.close();
        this.unionModel = null;
    }

    private static String nextURI() {
        return baseURI + ++labelCounter;
    }
}

