/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import org.apache.commons.logging.LogFactory;

public class DataSource1
implements DataSource {
    Model model;
    Graph graph;

    public DataSource1() {
        this(ModelFactory.createDefaultModel());
    }

    public DataSource1(String string) {
        this(FileManager.get(), string);
    }

    public DataSource1(FileManager fileManager, String string) {
    }

    public DataSource1(FileManager fileManager, String string, String string2) {
        try {
            this.model = fileManager.loadModel(string, string2, null);
            long l = this.model.size();
            this.graph = this.model.getGraph();
        }
        catch (JenaException jenaException) {
            LogFactory.getLog((Class)DataSource1.class).debug((Object)("Failed to load " + string + " (" + jenaException.getMessage() + ")"));
            throw new QueryException("Can't load data from: " + string, jenaException);
        }
    }

    public DataSource1(Model model) {
        this(model.getGraph());
        this.model = model;
    }

    public DataSource1(Graph graph) {
        if (graph == null) {
            LogFactory.getLog((Class)DataSource1.class).warn((Object)"Graph is null");
        }
        this.graph = graph;
        this.model = null;
    }

    public Model getModel() {
        if (this.model == null) {
            this.model = ModelFactory.createModelForGraph((Graph)this.graph);
        }
        return this.model;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public boolean isAggregate() {
        return false;
    }

    public void close() {
        if (this.model != null) {
            this.model.close();
        } else {
            this.graph.close();
        }
    }
}

