/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.util.ClosableFilterIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConstraintFilterIterator
extends ClosableFilterIterator {
    static Log log = LogFactory.getLog((Class)ConstraintFilterIterator.class);

    ConstraintFilterIterator(Mark mark, ClosableIterator closableIterator, List list) {
        super(new FilterByConstraints(mark, list), closableIterator);
    }

    static class FilterByConstraints
    implements ClosableFilterIterator.Filter {
        List constraints = null;
        Query query = null;
        Mark mark;

        FilterByConstraints(Mark mark, List list) {
            this.constraints = list;
            this.mark = mark;
        }

        public boolean accept(Object object) {
            Binding binding = (Binding)object;
            Iterator iterator = this.constraints.iterator();
            while (iterator.hasNext()) {
                Constraint constraint = (Constraint)iterator.next();
                if (constraint.isSatisfied(binding)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.mark.msg("Reject: " + constraint + " - " + binding));
                }
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg("Accept: " + this.tests() + " - " + binding));
            }
            return true;
        }

        String tests() {
            String string = "";
            Iterator iterator = this.constraints.iterator();
            while (iterator.hasNext()) {
                Constraint constraint = (Constraint)iterator.next();
                string = string + constraint;
            }
            return string;
        }
    }
}

