/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BasePatternIterator
extends QueryIterator {
    static Log log = LogFactory.getLog((Class)BasePatternIterator.class);
    boolean finished = false;
    Node[] projectionVars = null;
    Binding initialBinding;
    ClosableIterator graphIter;

    BasePatternIterator(Mark mark, DataSource dataSource, Binding binding, ElementBasePattern elementBasePattern, List list) {
        super(mark);
        this.initialBinding = binding;
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Start with: " + (this.initialBinding == null ? "<<null>>" : this.initialBinding.toString())));
        }
        QueryHandler queryHandler = dataSource.getGraph().queryHandler();
        Query query2 = new Query();
        HashSet hashSet = new HashSet();
        QueryEngineUtils.compilePattern(query2, elementBasePattern.pattern, this.initialBinding, hashSet);
        this.projectionVars = QueryEngineUtils.projectionVars(hashSet);
        QueryEngineUtils.compileConstraints(query2, list);
        BindingQueryPlan bindingQueryPlan = queryHandler.prepareBindings(query2, this.projectionVars);
        this.graphIter = bindingQueryPlan.executeBindings();
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        boolean bl = this.graphIter.hasNext();
        if (QueryIterator.LogHasNext && log.isDebugEnabled()) {
            log.debug((Object)this.mark.msg("hasNext: " + bl));
        }
        boolean bl2 = this.finished = !bl;
        if (this.finished) {
            this.close();
        }
        return bl;
    }

    public Object next() {
        Domain domain = (Domain)this.graphIter.next();
        Binding binding = BasePatternIterator.graphResultsToBinding(this.initialBinding, domain, this.projectionVars);
        if (log.isDebugEnabled()) {
            log.debug((Object)this.mark.msg("next: " + binding));
        }
        return binding;
    }

    public void close() {
        if (!this.finished) {
            log.debug((Object)this.mark.msg("close"));
            this.graphIter.close();
            this.finished = true;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    static Binding graphResultsToBinding(Binding binding, Domain domain, Node[] nodeArray) {
        BindingMap bindingMap = new BindingMap(binding);
        for (int i = 0; i < nodeArray.length; ++i) {
            String string = nodeArray[i].getName();
            Node node = (Node)domain.get(i);
            if (node == null) continue;
            bindingMap.add(string, node);
        }
        return bindingMap;
    }
}

