/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.resultset.PlainFormat;
import com.hp.hpl.jena.query.resultset.ResultSetApply;
import com.hp.hpl.jena.query.resultset.XMLOutput;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetFormatter {
    static Log log = LogFactory.getLog((Class)ResultSetFormatter.class);
    ResultSet resultSet;
    PrefixMapping prefixMapping = null;
    boolean reportAllVars = false;

    public ResultSetFormatter(ResultSet resultSet, PrefixMapping prefixMapping) {
        this.prefixMapping = prefixMapping;
        this.resultSet = resultSet;
    }

    public void close() {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.resultSet = null;
    }

    public boolean getAllVars() {
        return this.reportAllVars;
    }

    public void setAllVars(boolean bl) {
        this.reportAllVars = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume() {
        try {
            while (this.resultSet.hasNext()) {
                QuerySolution querySolution = this.resultSet.nextSolution();
                Iterator iterator = this.resultSet.getResultVars().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    querySolution.get(string);
                }
            }
            Object var5_4 = null;
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            throw throwable;
        }
    }

    public Model toModel() {
        Model model = ModelFactory.createDefaultModel();
        if (this.prefixMapping != null) {
            model.setNsPrefixes(this.prefixMapping);
        }
        this.asRDF(model);
        model.setNsPrefix("rs", ResultSetVocab.getURI());
        model.setNsPrefix("rdf", RDF.getURI());
        return model;
    }

    public Resource asRDF(Model model) {
        Object object;
        Resource resource = model.createResource();
        resource.addProperty(RDF.type, (RDFNode)ResultSetVocab.ResultSet);
        Iterator iterator = this.resultSet.getResultVars().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            resource.addProperty(ResultSetVocab.resultVariable, (String)object);
        }
        int n = 0;
        while (this.resultSet.hasNext()) {
            Iterator iterator2;
            ++n;
            object = this.resultSet.nextSolution();
            Resource resource2 = model.createResource();
            resource.addProperty(ResultSetVocab.solution, (RDFNode)resource2);
            Iterator iterator3 = iterator2 = this.getAllVars() ? object.varNames() : this.resultSet.getResultVars().iterator();
            while (iterator2.hasNext()) {
                Resource resource3 = model.createResource();
                String string = (String)iterator2.next();
                RDFNode rDFNode = object.get(string);
                if (rDFNode == null) continue;
                resource3.addProperty(ResultSetVocab.variable, string);
                resource3.addProperty(ResultSetVocab.value, rDFNode);
                resource2.addProperty(ResultSetVocab.binding, (RDFNode)resource3);
            }
        }
        return resource;
    }

    public void outputAsRDF(OutputStream outputStream, String string) {
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)outputStream);
        this.outputAsRDF(printWriter, string);
        printWriter.flush();
    }

    public void outputAsRDF(PrintWriter printWriter, String string) {
        Model model = this.toModel();
        model.write((Writer)printWriter, string);
    }

    public void outputAsText(OutputStream outputStream) {
        this.printPlain(outputStream);
    }

    public void printPlain(OutputStream outputStream) {
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)outputStream);
        PlainFormat plainFormat = new PlainFormat(outputStream, this.resultSet, this.prefixMapping);
        ResultSetApply resultSetApply = new ResultSetApply(this.resultSet, plainFormat);
        resultSetApply.apply();
        printWriter.flush();
    }

    public void outputAsXML(OutputStream outputStream) {
        this.outputAsXML(outputStream, null);
    }

    public void outputAsXML(OutputStream outputStream, String string) {
        XMLOutput xMLOutput = new XMLOutput(outputStream, string);
        ResultSetApply resultSetApply = new ResultSetApply(this.resultSet, xMLOutput);
        resultSetApply.apply();
    }
}

