/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetTextFormatter;
import com.hp.hpl.jena.query.core.ResultSetMem;
import com.hp.hpl.jena.query.resultset.ResultSetReader;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.FileInputStream;
import java.io.InputStream;

public class ResultSetFactory {
    public static ResultSet fromXML(InputStream inputStream) {
        return ResultSetReader.fromXML(inputStream);
    }

    public static ResultSet fromRDF(Model model) {
        return new ResultSetMem(model);
    }

    public static ResultSet makeResults(Model model) {
        return new ResultSetMem(model);
    }

    public static ResultSetRewindable makeRewindableResults(Model model) {
        return new ResultSetMem(model);
    }

    public static ResultSet copyResults(ResultSet resultSet) {
        return new ResultSetMem(resultSet);
    }

    public static ResultSetRewindable rewindableResults(ResultSet resultSet) {
        return new ResultSetMem(resultSet);
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            FileInputStream fileInputStream = new FileInputStream(string);
            ResultSet resultSet = ResultSetFactory.fromXML(fileInputStream);
            if (resultSet == null) {
                System.err.println("Result set is null");
                return;
            }
            ResultSetTextFormatter resultSetTextFormatter = new ResultSetTextFormatter(resultSet);
            resultSetTextFormatter.printAll(System.out);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
        }
    }
}

