/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.DescribeHandler;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.DataSource1;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementFormatter;
import com.hp.hpl.jena.query.core.FormatterARQ;
import com.hp.hpl.jena.query.core.FormatterPlain;
import com.hp.hpl.jena.query.core.QueryElement;
import com.hp.hpl.jena.query.parser.arq.ARQParser;
import com.hp.hpl.jena.query.parser.rdql.Q_Query;
import com.hp.hpl.jena.query.parser.rdql.RDQLParser;
import com.hp.hpl.jena.query.parser.sparql.ParseException;
import com.hp.hpl.jena.query.parser.sparql.SPARQLParser;
import com.hp.hpl.jena.query.parser.sparql.TokenMgrError;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.PrefixMapping2;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Query {
    static Log log = LogFactory.getLog((Class)Query.class);
    public static final String SyntaxARQ = "http://jena.hpl.hp.com/2003/07/query/ARQ";
    public static final String SyntaxRDQL = "http://jena.hpl.hp.com/2003/07/query/RDQL";
    public static final String SyntaxSPARQL = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
    public static final String SyntaxDebug = "http://jena.hpl.hp.com/2003/07/query/plain";
    public static final String SyntaxN3QL = "http://jena.hpl.hp.com/2003/07/query/N3QL";
    public static final int QueryTypeUnknown = -123;
    public static final int QueryTypeSelect = 111;
    public static final int QueryTypeConstruct = 222;
    public static final int QueryTypeDescribe = 333;
    public static final int QueryTypeAsk = 444;
    int queryType = -123;
    List sourceURIs = null;
    List namedSourceURIs = null;
    ElementBlock queryBlock = null;
    String syntax = null;
    public static int NOLIMIT = Integer.MIN_VALUE;
    int resultLimit = NOLIMIT;
    protected List resultVars = new ArrayList();
    protected boolean distinct = false;
    protected QueryElement constructPattern = null;
    protected List resultNodes = new ArrayList();
    protected DescribeHandler defaultDescribeHandler = null;
    protected String baseURI = null;
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();
    protected PrefixMapping2 prefixMap = new PrefixMapping2(globalPrefixMap, (PrefixMapping)new PrefixMappingImpl());
    static final int INDENT = 4;

    public static Query create(String string) {
        return Query.create(string, SyntaxSPARQL);
    }

    public static Query create(String string, String string2) {
        return Query.create(string, null, string2);
    }

    public static Query create(String string, String string2, String string3) {
        return Query.create(new Query(), string, string2, string3);
    }

    public static Query create(Query query2, String string, String string2, String string3) {
        query2.setBaseURI(string2);
        if (string3.equals(SyntaxARQ)) {
            return Query.Query_ARQ(query2, string);
        }
        if (string3.equals(SyntaxSPARQL)) {
            return Query.Query_SPARQL(query2, string);
        }
        if (string3.equals(SyntaxRDQL)) {
            return Query.Query_RDQL(query2, string);
        }
        if (string3.equals(SyntaxN3QL)) {
            return Query.Query_N3QL(query2, string);
        }
        if (string3.equals(SyntaxDebug)) {
            throw new UnsupportedOperationException("Parsing of syntax '" + string3 + "' not supported");
        }
        throw new UnsupportedOperationException("Unrecognized language: " + string3);
    }

    public void setType(int n) {
        this.queryType = n;
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public int getLimit() {
        return this.resultLimit;
    }

    public void setLimit(int n) {
        this.resultLimit = n;
    }

    public boolean hasLimit() {
        return this.resultLimit != NOLIMIT;
    }

    public boolean isSelectType() {
        return this.queryType == 111;
    }

    public boolean isConstructType() {
        return this.queryType == 222;
    }

    public boolean isDescribeType() {
        return this.queryType == 333;
    }

    public boolean isAskType() {
        return this.queryType == 444;
    }

    public boolean isUnknownType() {
        return this.queryType == -123;
    }

    public void setQueryElement(QueryElement queryElement) {
        if (this.queryBlock == null) {
            this.queryBlock = new ElementBlock(null, null);
        }
        this.queryBlock.setQueryElement(queryElement);
    }

    public void setDataSet(DataSource dataSource) {
        if (this.queryBlock == null) {
            this.queryBlock = new ElementBlock(null, null);
        }
        this.queryBlock.setDataSource(dataSource);
    }

    public void setDataSet(Model model) {
        this.setDataSet(new DataSource1(model));
    }

    public DataSource getDataSet() {
        if (this.queryBlock == null) {
            return null;
        }
        return this.queryBlock.getDataSource();
    }

    public void setQueryBlock(ElementBlock elementBlock) {
        this.queryBlock = elementBlock;
    }

    public ElementBlock getQueryBlock() {
        return this.queryBlock;
    }

    public void addSourceURI(String string) {
        if (this.sourceURIs == null) {
            this.sourceURIs = new ArrayList();
        }
        this.sourceURIs.add(string);
    }

    public void addNamedSourceURI(String string) {
        if (this.namedSourceURIs == null) {
            this.namedSourceURIs = new ArrayList();
        }
        this.namedSourceURIs.add(string);
    }

    public List getSourceURIs() {
        return this.sourceURIs;
    }

    public List getNamedSourceURIs() {
        return this.namedSourceURIs;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public void addResultVar(String string) {
        if (!this.resultVars.contains(string)) {
            this.resultVars.add(string);
        }
    }

    public void addResultVar(Node node) {
        if (!node.isVariable()) {
            throw new QueryException("Not a variable: " + node);
        }
        this.addResultVar(node.getName());
    }

    public void addDescribeNode(Node node) {
        if (node.isVariable()) {
            this.addResultVar(node);
            return;
        }
        if (node.isURI()) {
            this.addResultURIs(node);
            return;
        }
        if (node.isLiteral()) {
            throw new QueryException("Result node is a literal: " + QueryPrintUtils.stringForNode(node));
        }
        throw new QueryException("Result node not recognized: " + QueryPrintUtils.stringForNode(node));
    }

    public QueryElement getConstructPattern() {
        return this.constructPattern;
    }

    public void setConstructPattern(QueryElement queryElement) {
        this.constructPattern = queryElement;
    }

    public List getResultURIs() {
        return this.resultNodes;
    }

    public void addResultURIs(Node node) {
        if (node.isLiteral()) {
            throw new QueryException("Result URI is a literal: " + QueryPrintUtils.stringForNode(node));
        }
        if (!this.resultNodes.contains(node)) {
            this.resultNodes.add(node);
        }
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void setPrefix(String string, String string2) {
        try {
            this.prefixMap.setNsPrefix(string, string2);
        }
        catch (PrefixMapping.IllegalPrefixException illegalPrefixException) {
            log.warn((Object)("Illegal prefix mapping(ignored): " + string + "=>" + string2));
        }
    }

    public PrefixMapping getPrefixMap() {
        return this.prefixMap;
    }

    public PrefixMapping getLocalPrefixMap() {
        return this.prefixMap.getLocalPrefixMapping();
    }

    public PrefixMapping getGlobalPrefixMap() {
        return this.prefixMap.getGlobalPrefixMapping();
    }

    public String getPrefix(String string) {
        return this.prefixMap.getNsPrefixURI(string);
    }

    public String expandQName(String string) {
        String string2 = this.prefixMap.expandPrefix(string);
        if (string2.equals(string)) {
            return null;
        }
        return string2;
    }

    public String shortForm(String string) {
        return this.prefixMap.shortForm(string);
    }

    private static Query Query_RDQL(Query query2, String string) {
        query2.syntax = SyntaxRDQL;
        Q_Query q_Query = null;
        try {
            StringReader stringReader = new StringReader(string);
            RDQLParser rDQLParser = new RDQLParser(stringReader);
            rDQLParser.CompilationUnit();
            q_Query = (Q_Query)rDQLParser.top();
            q_Query.rdqlPhase2(query2);
            return query2;
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (com.hp.hpl.jena.query.parser.rdql.ParseException parseException) {
            throw new QueryException("Parse error: " + parseException.getMessage());
        }
        catch (Error error) {
            throw new QueryException("Parse error: " + error.getMessage());
        }
        catch (Exception exception) {
            throw new QueryException("Unexpected exception: " + exception.getMessage());
        }
    }

    private static Query Query_SPARQL(Query query2, String string) {
        try {
            StringReader stringReader = new StringReader(string);
            SPARQLParser sPARQLParser = new SPARQLParser(stringReader);
            sPARQLParser.setQuery(query2);
            sPARQLParser.CompilationUnit();
            query2.syntax = SyntaxSPARQL;
            Query.queryStep2(query2);
            return query2;
        }
        catch (ParseException parseException) {
            throw new QueryException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new QueryException(tokenMgrError.getMessage());
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Throwable throwable) {
            log.warn((Object)"Unexpected throwable: ", throwable);
            throw new QueryException(throwable);
        }
    }

    private static Query Query_ARQ(Query query2, String string) {
        try {
            StringReader stringReader = new StringReader(string);
            ARQParser aRQParser = new ARQParser(stringReader);
            aRQParser.setQuery(query2);
            aRQParser.CompilationUnit();
            query2.syntax = SyntaxARQ;
            Query.queryStep2(query2);
            return query2;
        }
        catch (com.hp.hpl.jena.query.parser.arq.ParseException parseException) {
            throw new QueryException(parseException.getMessage());
        }
        catch (com.hp.hpl.jena.query.parser.arq.TokenMgrError tokenMgrError) {
            throw new QueryException(tokenMgrError.getMessage());
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Throwable throwable) {
            log.warn((Object)"Unexpected throwable: ", throwable);
            throw new QueryException(throwable);
        }
    }

    private static Query Query_N3QL(Query query2, String string) {
        throw new UnsupportedOperationException("Not implemented: parsing N3QL syntax");
    }

    private static void queryStep2(Query query2) {
        if (query2.isSelectType()) {
            if (query2.getQueryBlock() == null) {
                throw new QueryException("Missing WHERE clause in SELECT query");
            }
            if (query2.getResultVars() == null || query2.getResultVars().size() == 0) {
                Set set = query2.getQueryBlock().varsBound();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    query2.addResultVar((String)iterator.next());
                }
            }
        }
        if (query2.isConstructType()) {
            if (query2.getQueryBlock() == null) {
                throw new QueryException("Missing WHERE clause in CONSTRUCT query");
            }
            if (query2.getConstructPattern() == null) {
                query2.setConstructPattern(query2.getQueryBlock().getQueryElement());
            }
        }
        if (query2.isAskType() && query2.getQueryBlock() == null) {
            throw new QueryException("Missing WHERE clause in ASK query");
        }
        if (query2.getQueryBlock() != null) {
            query2.getQueryBlock().phase2();
        }
    }

    public String toString() {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        this.unparse(indentedLineBuffer);
        return indentedLineBuffer.toString();
    }

    public void unparse(IndentedLineBuffer indentedLineBuffer) {
        String string = this.syntax;
        if (string == null) {
            string = SyntaxSPARQL;
        }
        this.unparse(indentedLineBuffer, string);
    }

    public void unparse(IndentedLineBuffer indentedLineBuffer, String string) {
        if (string.equals(SyntaxARQ)) {
            this.unparseARQ(indentedLineBuffer);
            return;
        }
        if (string.equals(SyntaxRDQL)) {
            this.unparseRDQL(indentedLineBuffer);
            return;
        }
        if (string.equals(SyntaxSPARQL)) {
            this.unparseSPARQL(indentedLineBuffer);
            return;
        }
        if (string.equals(SyntaxN3QL)) {
            this.unparseN3QL(indentedLineBuffer);
            return;
        }
        if (string.equals(SyntaxDebug)) {
            this.unparsePlain(indentedLineBuffer);
            return;
        }
        log.warn((Object)("Unknown syntax: " + string));
    }

    public void unparseARQ(IndentedLineBuffer indentedLineBuffer) {
        this.unparseARQ(indentedLineBuffer, new FormatterARQ());
    }

    public void unparseARQ(IndentedLineBuffer indentedLineBuffer, ElementFormatter elementFormatter) {
        Object object;
        Map map;
        if (this.baseURI != null) {
            indentedLineBuffer.append("BASE   ");
            indentedLineBuffer.append("<" + this.baseURI + ">");
            indentedLineBuffer.newline();
        }
        if ((map = this.prefixMap.getNsPrefixMap()).size() > 0) {
            boolean bl = true;
            object = map.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = (String)map.get(string);
                indentedLineBuffer.append("PREFIX  ");
                indentedLineBuffer.append(string + ": <" + string2 + ">");
                indentedLineBuffer.newline();
            }
        }
        if (this.isSelectType()) {
            indentedLineBuffer.append("SELECT");
            if (this.isDistinct()) {
                indentedLineBuffer.append(" DISTINCT");
            }
            if (this.resultVars.size() != 0 || this.resultNodes.size() != 0) {
                this.appendVarList(indentedLineBuffer, this.resultVars);
            } else {
                indentedLineBuffer.append(" *");
            }
            indentedLineBuffer.newline();
        }
        if (this.isDescribeType()) {
            indentedLineBuffer.append("DESCRIBE");
            if (this.resultVars.size() != 0 || this.resultNodes.size() != 0) {
                this.appendVarList(indentedLineBuffer, this.resultVars);
                this.appendURIList(indentedLineBuffer, this.resultNodes);
            } else {
                indentedLineBuffer.append(" *");
            }
            indentedLineBuffer.newline();
        }
        if (this.isConstructType()) {
            indentedLineBuffer.append("CONSTRUCT");
            if (this.getConstructPattern() == this.getQueryBlock().getQueryElement()) {
                indentedLineBuffer.append(" *");
                indentedLineBuffer.newline();
            } else {
                indentedLineBuffer.incIndent(4);
                indentedLineBuffer.newline();
                elementFormatter.format(indentedLineBuffer, this, (Element)this.getConstructPattern());
                indentedLineBuffer.decIndent(4);
                indentedLineBuffer.newline();
            }
        }
        if (this.isAskType()) {
            indentedLineBuffer.append("ASK");
        }
        if (this.isUnknownType()) {
            indentedLineBuffer.append("<<UNKNOWN>>");
        }
        if (this.getSourceURIs() != null) {
            indentedLineBuffer.append("FROM  ");
            Iterator iterator = this.getSourceURIs().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                indentedLineBuffer.append(" ");
                indentedLineBuffer.append(this.formatURI((String)object));
            }
            indentedLineBuffer.newline();
        }
        if (this.getNamedSourceURIs() != null) {
            indentedLineBuffer.append("GRAPH ");
            Iterator iterator = this.getNamedSourceURIs().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                indentedLineBuffer.append(" ");
                indentedLineBuffer.append(this.formatURI((String)object));
            }
            indentedLineBuffer.newline();
        }
        if (this.getQueryBlock() != null && this.getQueryBlock().getQueryElement() != null) {
            indentedLineBuffer.append("WHERE");
            indentedLineBuffer.incIndent(4);
            indentedLineBuffer.newline();
            elementFormatter.format(indentedLineBuffer, this, this.getQueryBlock());
            indentedLineBuffer.decIndent(4);
            indentedLineBuffer.newline();
        }
        if (this.hasLimit()) {
            indentedLineBuffer.append("LIMIT " + this.getLimit());
            indentedLineBuffer.newline();
        }
    }

    public void unparseSPARQL(IndentedLineBuffer indentedLineBuffer) {
        log.warn((Object)"# unparseSPARQL: Not implemented - Native syntax instead");
        this.unparseARQ(indentedLineBuffer);
    }

    public void unparseRDQL(IndentedLineBuffer indentedLineBuffer) {
        log.warn((Object)"# unparseRDQL: Not implemented - Native syntax instead");
        this.unparseARQ(indentedLineBuffer);
    }

    public void unparsePlain(IndentedLineBuffer indentedLineBuffer) {
        this.unparseARQ(indentedLineBuffer, new FormatterPlain());
    }

    public void unparseN3QL(IndentedLineBuffer indentedLineBuffer) {
        throw new UnsupportedOperationException("Not implemented: Formatting a query in N3QL syntax");
    }

    void appendVarList(IndentedLineBuffer indentedLineBuffer, List list) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            indentedLineBuffer.append(" ");
            indentedLineBuffer.append("?");
            indentedLineBuffer.append(string);
            bl = false;
        }
    }

    void appendURIList(IndentedLineBuffer indentedLineBuffer, List list) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            indentedLineBuffer.append(" ");
            indentedLineBuffer.append(this.formatURI(node.getURI()));
            bl = false;
        }
    }

    private String formatURI(String string) {
        String string2 = this.prefixMap.qnameFor(string);
        if (string2 == null || string2.equals(string)) {
            string2 = "<" + string + ">";
        }
        return string2;
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        globalPrefixMap.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
    }
}

