/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.ArgDecl;
import arq.cmdline.CommandLine;
import arq.cmdline.TranslationTable;
import arq.cmdutil.CmdUtils;
import arq.cmdutil.QueryContext;
import arq.cmdutil.RunQuery;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class query {
    static String defaultSyntax;
    String dbUser = "";
    String dbPassword = "";
    String dbType = "";
    String dbName = "";
    String dbDriver = null;
    protected static Log log;
    static TranslationTable resultFormats;

    public static void main(String[] stringArray) {
        Object object;
        String string;
        boolean bl;
        if (stringArray.length == 0) {
            query.usage();
            System.exit(0);
        }
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "h", "help");
        commandLine.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "v", "verbose");
        commandLine.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "q", "quiet");
        commandLine.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(true, "data");
        commandLine.add(argDecl4);
        ArgDecl argDecl5 = new ArgDecl(true, "query");
        commandLine.add(argDecl5);
        ArgDecl argDecl6 = new ArgDecl(true, "syntax", "syn");
        commandLine.add(argDecl6);
        ArgDecl argDecl7 = new ArgDecl(true, "fmt", "format");
        commandLine.add(argDecl7);
        ArgDecl argDecl8 = new ArgDecl(true, "results", "rfmt");
        commandLine.add(argDecl8);
        ArgDecl argDecl9 = new ArgDecl(true, "dir");
        commandLine.add(argDecl9);
        ArgDecl argDecl10 = new ArgDecl(true, "base");
        commandLine.add(argDecl10);
        ArgDecl argDecl11 = new ArgDecl(true, "lmap");
        commandLine.add(argDecl11);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            query.usage(System.err);
            System.exit(2);
        }
        if (commandLine.contains(argDecl)) {
            query.usage();
            System.exit(0);
        }
        QueryContext queryContext = new QueryContext();
        boolean bl2 = commandLine.contains(argDecl2);
        if (bl2) {
            ++queryContext.messageLevel;
        }
        if (bl = commandLine.contains(argDecl3)) {
            --queryContext.messageLevel;
        }
        if (commandLine.contains(argDecl9)) {
            string = commandLine.getValue(argDecl9);
            queryContext.fileManager = new FileManager();
            queryContext.fileManager.addLocatorFile(string);
            queryContext.fileManager.addLocatorURL();
        } else {
            queryContext.fileManager = FileManager.get();
        }
        if (commandLine.contains(argDecl10)) {
            queryContext.baseURI = commandLine.getValue(argDecl10);
            RelURI.setBaseURI(queryContext.baseURI);
        }
        if (commandLine.contains(argDecl11)) {
            string = commandLine.getValue(argDecl11);
            object = new LocationMapper(string);
            queryContext.fileManager.setMapper(object);
        }
        if (commandLine.contains(argDecl6)) {
            string = commandLine.getValue(argDecl6);
            queryContext.syntax = CmdUtils.querySyntaxNames.lookup(string);
            if (queryContext.syntax == null) {
                query.argError("Unrecognized syntax: " + string);
            }
        }
        string = commandLine.getValue(argDecl5);
        if (commandLine.items().size() == 0 && string == null) {
            query.argError("No query string or query file");
        }
        if (commandLine.items().size() > 1) {
            query.argError("Only one query string allowed");
        }
        if (commandLine.items().size() == 1 && string != null) {
            query.argError("Either query string or query file - not both");
        }
        if (string != null) {
            if (queryContext.syntax == null) {
                queryContext.syntax = CmdUtils.guessQueryFileSyntax(string, defaultSyntax);
            }
            try {
                queryContext.queryString = FileManager.get().readWholeFileAsUTF8(string);
            }
            catch (Exception exception) {
                System.err.println("Failed to read query file: " + string);
                System.exit(1);
            }
        } else {
            queryContext.queryString = (String)commandLine.items().get(0);
        }
        if (queryContext.syntax == null) {
            queryContext.syntax = defaultSyntax;
        }
        if (commandLine.contains(argDecl4)) {
            queryContext.dataURL = commandLine.getValue(argDecl4);
        }
        if (commandLine.contains(argDecl7)) {
            object = commandLine.getValue(argDecl7);
            queryContext.dataSyntax = CmdUtils.dataSyntaxNames.lookup((String)object);
            if (queryContext.dataSyntax == null) {
                query.argError("Unrecognized syntax for data: " + (String)object);
            }
        }
        if (commandLine.contains(argDecl8)) {
            object = commandLine.getValue(argDecl8);
            queryContext.outputFormat = resultFormats.lookup((String)object);
            if (queryContext.outputFormat == null) {
                query.argError("Unrecognized output format: " + (String)object);
            }
        }
        try {
            RunQuery.query(queryContext);
        }
        catch (Exception exception) {
            System.err.println("Exception from RunQuery: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(9);
        }
    }

    static void usage() {
        query.usage(System.out);
    }

    static void usage(PrintStream printStream) {
        printStream.println("Usage: [--data URL] [queryString | --query file]");
        printStream.println("   --query file     Read one query from a file");
        printStream.println("   --syntax SYN     Query syntax");
        printStream.println("                      SPARQL (default), ARQ, RDQL, N3QL");
        printStream.println("                      File suffixes imply syntax:");
        printStream.println("                      .rq / SPARQL,  .arq / ARQ, .rdql / RDQL");
        printStream.println("   --data URL       DataSource source (can also be part of query)");
        printStream.println("   --fmt FMT        Data source format: RDF/XML (default),");
        printStream.println("                      N3, N-TRIPLES, TURTLE");
        printStream.println("                      Note: file extensions used to guess the format as well");
        printStream.println("                      .rdf, .n3, .nt, .ttl");
        printStream.println("   --results FORM   Format of result (SELECT queries)");
        printStream.println("                      text [default], tuples, none for display");
        printStream.println("                      rs, rs/graph, rs/xml, rs/text for the result set ");
        printStream.println("   --verbose        Verbose - more messages");
        printStream.println("   --quiet          Quiet - less messages");
    }

    static void argError(String string) {
        System.err.println("Argument Error: " + string);
        System.exit(3);
    }

    private void printNL(String string) {
        System.out.print(string);
        if (!string.endsWith("\n")) {
            System.out.println();
        }
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        defaultSyntax = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        log = LogFactory.getLog((Class)query.class);
        resultFormats = new TranslationTable(true);
        resultFormats.put("none", "none");
        resultFormats.put("tuples", "tuples");
        resultFormats.put("text", "text");
        resultFormats.put("xml", "rs/xml");
        resultFormats.put("rs", "rs/graph");
        resultFormats.put("rs/text", "rs/text");
        resultFormats.put("rs/raw", "rs/text");
        resultFormats.put("rs/graph", "rs/xml");
        resultFormats.put("rs/xml", "rs/xml");
    }
}

