/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.ArgDecl;
import arq.cmdline.CommandLine;
import arq.cmdutil.CmdUtils;
import com.hp.hpl.jena.query.test.ARQTestSuite;
import com.hp.hpl.jena.query.test.QueryTestScriptsManifest;
import com.hp.hpl.jena.query.test.SimpleTestRunner;
import com.hp.hpl.jena.query.util.RelURI;
import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestSuite;

public class qtest {
    static String usage;

    public static void main(String[] stringArray) {
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "h", "help");
        commandLine.add(argDecl);
        ArgDecl argDecl2 = new ArgDecl(false, "all");
        commandLine.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "wg", "dawg");
        commandLine.add(argDecl3);
        ArgDecl argDecl4 = new ArgDecl(true, "dir");
        commandLine.add(argDecl4);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            qtest.usage(System.err);
            System.exit(2);
        }
        if (commandLine.contains(argDecl) || !commandLine.hasArgs() && !commandLine.hasItems()) {
            qtest.usage();
            System.exit(0);
        }
        if (commandLine.contains(argDecl2)) {
            qtest.allTests();
            System.exit(0);
        }
        if (commandLine.contains(argDecl3)) {
            qtest.dawgTests();
            System.exit(0);
        }
        String string = null;
        if (commandLine.contains(argDecl4)) {
            string = commandLine.getValue(argDecl4);
        }
        if (commandLine.items().size() == 0) {
            qtest.argError("No query test file");
        }
        String string2 = (String)commandLine.items().get(0);
        String string3 = RelURI.resolveFileURL(string2);
        qtest.oneTest(string3, string);
    }

    static void oneTest(String string, String string2) {
        if (string != null) {
            qtest.doTestManifest(string, string2);
            System.exit(0);
        }
    }

    static void allTests() {
        TestSuite testSuite = ARQTestSuite.suite();
        SimpleTestRunner.runAndReport((Test)testSuite);
    }

    static void dawgTests() {
        System.err.println("DAWG tests not packaged up yet");
        System.exit(4);
    }

    public static void doTestManifest(String string, String string2) {
        QueryTestScriptsManifest queryTestScriptsManifest = new QueryTestScriptsManifest("ARQ", string2, string);
        SimpleTestRunner.runAndReport((Test)queryTestScriptsManifest);
    }

    static void usage() {
        qtest.usage(System.err);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static void argError(String string) {
        System.err.println("Argument Error: " + string);
        System.exit(3);
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        usage = qtest.class.getName() + " [--all]\n" + qtest.class.getName() + " [--dawg]\n" + qtest.class.getName() + " [--dir DIRECTORY] manifest\n" + " where --all      run all built-in tests\n" + "       --dawg     run working group tests\n" + "       manifest   run a set of tests";
    }
}

