/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.Arg;
import arq.cmdline.ArgDecl;
import arq.cmdline.CommandLine;
import arq.cmdutil.CmdUtils;
import arq.cmdutil.RunQuery;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;

public class qparse {
    static String usage;

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string = null;
        String string2 = null;
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "v", "verbose");
        ArgDecl argDecl2 = new ArgDecl(false, "h", "help");
        ArgDecl argDecl3 = new ArgDecl(false, "debug");
        ArgDecl argDecl4 = new ArgDecl(true, "in");
        ArgDecl argDecl5 = new ArgDecl(true, "out");
        ArgDecl argDecl6 = new ArgDecl(true, "file", "query");
        commandLine.add(argDecl);
        commandLine.add(argDecl3);
        commandLine.add(argDecl2);
        commandLine.add(argDecl6);
        commandLine.add(argDecl4);
        commandLine.add(argDecl5);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(9);
        }
        if (commandLine.contains(argDecl2)) {
            qparse.usage();
            System.exit(0);
        }
        if (commandLine.contains(argDecl4)) {
            object2 = CmdUtils.querySyntaxNames.lookup(commandLine.getValue(argDecl4));
            if (object2 == null) {
                qparse.msg("Unknown query syntax for input: " + commandLine.getArg(argDecl4).getValue());
                qparse.writeSyntaxes("Known syntaxes", System.err);
                System.exit(9);
            }
            string = object2;
        }
        if (commandLine.contains(argDecl5)) {
            object2 = CmdUtils.querySyntaxNames.lookup(commandLine.getValue(argDecl5));
            if (object2 == null) {
                qparse.msg("Unknown query syntax for output: " + commandLine.getArg(argDecl4).getValue());
                qparse.writeSyntaxes("Known syntaxes", System.err);
                System.exit(9);
            }
            string2 = object2;
        }
        if (string2 == null) {
            string2 = "http://jena.hpl.hp.com/2003/07/query/ARQ";
        }
        if (commandLine.args().size() == 0 && commandLine.items().size() == 0) {
            commandLine.items().add("-");
        }
        object2 = commandLine.args().iterator();
        while (object2.hasNext()) {
            object = (Arg)object2.next();
            if (!((Arg)object).matches(argDecl6)) continue;
            qparse.parseFromFile(((Arg)object).getValue(), string, string2);
        }
        if (string == null) {
            string = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        }
        object2 = commandLine.items().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (((String)object).equals("-")) {
                try {
                    object = FileUtils.readWholeFileAsUTF8((InputStream)System.in);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            qparse.parseString((String)object, string, string2);
        }
    }

    static void parseFromFile(String string, String string2, String string3) {
        String string4 = null;
        try {
            string4 = FileUtils.readWholeFileAsUTF8((String)string);
        }
        catch (IOException iOException) {
            System.err.println("Failed to read file: " + string + " :: " + iOException.getMessage());
            System.exit(1);
        }
        String string5 = string2;
        if (string5 == null) {
            string5 = CmdUtils.guessQueryFileSyntax(string, "http://jena.hpl.hp.com/2003/07/query/SPARQL");
        }
        if (string5 == null) {
            string5 = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        }
        qparse.parseString(string4, string5, string3);
    }

    static void parseString(String string, String string2, String string3) {
        Query query2 = null;
        try {
            query2 = RunQuery.parseQuery(string, string2);
            if (query2 == null) {
                return;
            }
        }
        catch (QueryException queryException) {
            qparse.printNL(string);
            System.out.println(queryException.getMessage());
            return;
        }
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        IndentedLineBuffer indentedLineBuffer2 = new IndentedLineBuffer(true);
        query2.unparse(indentedLineBuffer, string3);
        query2.unparse(indentedLineBuffer2, string3);
        qparse.printNL(indentedLineBuffer2.toString());
        String string4 = indentedLineBuffer.toString();
        if (!string3.equals("http://jena.hpl.hp.com/2003/07/query/plain")) {
            try {
                query2 = RunQuery.parseQuery(string4, string3);
                if (query2 == null) {
                    return;
                }
            }
            catch (QueryException queryException) {
                System.out.println("Printed-parsed query in error: ");
                qparse.printNL(string4);
                System.out.println(queryException.getMessage());
            }
        }
    }

    static void writeSyntaxes(String string, PrintStream printStream) {
        if (string != null) {
            printStream.println(string);
        }
        Iterator iterator = CmdUtils.querySyntaxNames.keys();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            string2 = qparse.padOut(string2, 6);
            printStream.println(string2 + "  " + string3);
        }
    }

    static void msg(String string) {
        System.err.println(string);
    }

    static String padOut(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i <= n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    static void printNL(String string) {
        System.out.print(string);
        if (!string.endsWith("\n")) {
            System.out.println();
        }
    }

    static void usage() {
        qparse.msg(usage);
    }

    static void usage(PrintStream printStream) {
        printStream.println(usage);
    }

    static {
        CmdUtils.setLog4j();
        usage = qparse.class.getName() + " [--in syntax] [--out syntax] [\"query\" | --query <file>\n" + "  where syntax is one of ARQ, SPARQL, RDQL\n" + "  and the query comes from stdin or the command line";
    }
}

