/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdutil;

import arq.cmdutil.QueryContext;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetTextFormatter;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunQuery {
    public static final String FMT_NONE = "none";
    public static final String FMT_TUPLES = "tuples";
    public static final String FMT_TEXT = "text";
    public static final String FMT_RS_RDF = "rs/graph";
    public static final String FMT_RS_TEXT = "rs/text";
    public static final String FMT_RS_XML = "rs/xml";
    static String vocabularyURI = null;
    static Model vocabulary = null;
    protected static Log log = LogFactory.getLog((Class)RunQuery.class);

    public static void query(String string, String string2, FileManager fileManager, String string3, String string4, String string5, int n) {
        QueryContext queryContext = new QueryContext();
        queryContext.queryString = string;
        queryContext.syntax = string2;
        queryContext.fileManager = fileManager;
        queryContext.dataURL = string3;
        queryContext.dataSyntax = string4;
        queryContext.outputFormat = string5;
        queryContext.messageLevel = n;
        RunQuery.query(queryContext);
    }

    public static void query(QueryContext queryContext) {
        RunQuery.queryFixDataSource(queryContext);
        RunQuery.dumpData(queryContext);
        RunQuery.queryFixOutputFormat(queryContext);
        RunQuery.queryCreateQuery(queryContext);
        if (queryContext.query == null) {
            return;
        }
        RunQuery.dumpQuery(queryContext);
        RunQuery.queryBindData(queryContext);
        if (queryContext.query.getDataSet() == null && queryContext.query.getSourceURIs() == null && queryContext.query.getNamedSourceURIs() == null) {
            System.err.println("Dataset not specificed in query nor provided on command line.");
            return;
        }
        RunQuery.queryExec(queryContext);
    }

    static void queryFixDataSource(QueryContext queryContext) {
        try {
            if (queryContext.fileManager == null) {
                queryContext.fileManager = FileManager.get();
            }
            if (queryContext.dataURL != null) {
                queryContext.model = queryContext.fileManager.loadModel(queryContext.dataURL, queryContext.baseURI, queryContext.dataSyntax);
            }
        }
        catch (Exception exception) {
            System.err.println("Error loading URL " + queryContext.dataURL);
            System.exit(1);
        }
    }

    static void queryFixOutputFormat(QueryContext queryContext) {
        if (queryContext.outputFormat == null) {
            queryContext.outputFormat = FMT_TEXT;
        }
    }

    static void queryCreateQuery(QueryContext queryContext) {
        if (queryContext.query == null) {
            if (queryContext.syntax == null) {
                queryContext.syntax = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
            }
            queryContext.query = RunQuery.parseQuery(queryContext.queryString, queryContext.syntax);
            if (queryContext.query == null) {
                return;
            }
        }
        if (queryContext.baseURI != null) {
            queryContext.query.setBaseURI(queryContext.baseURI);
        }
    }

    static void queryBindData(QueryContext queryContext) {
        if (queryContext.model != null) {
            queryContext.query.setDataSet(queryContext.model);
        }
    }

    static void queryExec(QueryContext queryContext) {
        try {
            QueryExecution queryExecution = QueryFactory.createQueryExecution(queryContext.query);
            if (queryContext.fileManager != null) {
                queryExecution.setFileManager(queryContext.fileManager);
            }
            queryExecution.init();
            RunQuery.doQuery(queryContext.query, queryExecution, queryContext.outputFormat);
            queryExecution.close();
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
        }
        catch (QueryException queryException) {
            System.err.println(queryException.getMessage());
            System.exit(9);
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
        }
    }

    public static Query parseQuery(String string, String string2) {
        try {
            Query query2 = Query.create(string, string2);
            return query2;
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
            return null;
        }
        catch (QueryException queryException) {
            System.err.println(queryException.getMessage());
            return null;
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static void doQuery(Query query2, QueryExecution queryExecution, String string) {
        if (query2.isSelectType()) {
            RunQuery.doSelectQuery(query2, queryExecution, string);
        }
        if (query2.isDescribeType()) {
            RunQuery.doDescribeQuery(query2, queryExecution, string);
        }
        if (query2.isConstructType()) {
            RunQuery.doConstructQuery(query2, queryExecution, string);
        }
        if (query2.isAskType()) {
            RunQuery.doAskQuery(query2, queryExecution, string);
        }
    }

    static void doSelectQuery(Query query2, QueryExecution queryExecution, String string) {
        Object object;
        Object object2;
        ResultSet resultSet = queryExecution.execSelect();
        resultSet = ResultSetFactory.rewindableResults(resultSet);
        boolean bl = false;
        if (string.equals(FMT_NONE)) {
            object2 = new ResultSetFormatter(resultSet, query2.getPrefixMap());
            ((ResultSetFormatter)object2).consume();
            ((ResultSetFormatter)object2).close();
            bl = true;
        }
        if (string.equals(FMT_RS_RDF)) {
            object2 = new ResultSetFormatter(resultSet, query2.getPrefixMap());
            object = ((ResultSetFormatter)object2).toModel();
            RDFWriter rDFWriter = object.getWriter("TURTLE");
            object.setNsPrefix("rs", ResultSetVocab.getURI());
            rDFWriter.write((Model)object, (OutputStream)System.out, null);
            ((ResultSetFormatter)object2).close();
            bl = true;
        }
        object2 = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        if (string.equals(FMT_RS_XML)) {
            object = new ResultSetFormatter(resultSet, query2.getPrefixMap());
            ((ResultSetFormatter)object).outputAsXML(System.out);
            ((ResultSetFormatter)object).close();
            bl = true;
        }
        if (string.equals(FMT_RS_TEXT)) {
            object = new ResultSetFormatter(resultSet, query2.getPrefixMap());
            ((ResultSetFormatter)object).outputAsText(System.out);
            bl = true;
        }
        object = null;
        if (string.equals(FMT_TEXT)) {
            object = new ResultSetTextFormatter(resultSet, query2.getPrefixMap());
            ((ResultSetTextFormatter)object).printAll((PrintWriter)object2);
            bl = true;
        }
        if (string.equals(FMT_TUPLES)) {
            object = new ResultSetTextFormatter(resultSet);
            ((ResultSetTextFormatter)object).dump((PrintWriter)object2, true);
            bl = true;
        }
        if (!bl) {
            log.warn((Object)("Unknown format request: " + string));
        }
        if (object2 != null) {
            ((PrintWriter)object2).flush();
        }
        if (object != null) {
            ((ResultSetTextFormatter)object).close();
        }
        resultSet.close();
        if (query2.getQueryBlock().getDataSource() != null) {
            query2.getQueryBlock().getDataSource().close();
        }
    }

    static void doDescribeQuery(Query query2, QueryExecution queryExecution, String string) {
        Model model = queryExecution.execDescribe();
        if (!string.equals(FMT_NONE)) {
            System.out.println("======== DESCRIBE results ");
            model.write((OutputStream)System.out, "N3", null);
        }
        System.out.println("======== ");
    }

    static void doConstructQuery(Query query2, QueryExecution queryExecution, String string) {
        Model model = queryExecution.execConstruct();
        System.out.println();
        if (!string.equals(FMT_NONE)) {
            System.out.println("======== CONSTRUCT results ");
            model.write((OutputStream)System.out, "N3", null);
            System.out.println("======== ");
        }
    }

    static void doAskQuery(Query query2, QueryExecution queryExecution, String string) {
        boolean bl = queryExecution.execAsk();
        if (!string.equals(FMT_NONE)) {
            System.out.println("Ask => " + (bl ? "Yes" : "No"));
        }
    }

    static void dumpQuery(QueryContext queryContext) {
        if (queryContext.messageLevel > 0) {
            System.out.println("Parsed query:");
            IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer(true);
            queryContext.query.unparseARQ(indentedLineBuffer);
            String string = indentedLineBuffer.toString();
            System.out.print(string);
            if (!string.endsWith("\n")) {
                System.out.println();
            }
            System.out.println();
        }
    }

    static void dumpData(QueryContext queryContext) {
        boolean bl = false;
        if (bl) {
            System.out.println("# Model --------------------------------------------------------------------------------");
            queryContext.model.write((OutputStream)System.out, "N3");
            System.out.println("# Model --------------------------------------------------------------------------------");
            System.out.flush();
        }
    }
}

