/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.Arg;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgHandler;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandLine {
    protected ArgHandler argHook = null;
    protected String usage = null;
    protected Map argMap = new HashMap();
    protected Set argValue = new HashSet();
    protected boolean ignoreUnknown = false;
    protected List args = new ArrayList();
    protected List items = new ArrayList();

    public void setHook(ArgHandler argHandler) {
        this.argHook = argHandler;
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    public boolean hasArgs() {
        return this.args.size() > 0;
    }

    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public List args() {
        return this.args;
    }

    public List items() {
        return this.items;
    }

    public void process(String[] stringArray) throws IllegalArgumentException {
        String string;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        for (n = 0; n < arrayList.size() && (string = (String)arrayList.get(n)).startsWith("-") && !string.equals("--") && !string.equals("-"); ++n) {
            int n2 = string.indexOf(61);
            int n3 = string.indexOf(58);
            int n4 = Integer.MAX_VALUE;
            if (n2 > 0 && n2 < n4) {
                n4 = n2;
            }
            if (n3 > 0 && n3 < n4) {
                n4 = n3;
            }
            if (n4 != Integer.MAX_VALUE) {
                String string2 = string.substring(n4 + 1);
                arrayList.add(n + 1, string2);
                string = string.substring(0, n4);
            }
            string = ArgDecl.canonicalForm(string);
            String string3 = null;
            if (this.argMap.containsKey(string)) {
                Arg arg = new Arg(string);
                ArgDecl argDecl = (ArgDecl)this.argMap.get(string);
                if (argDecl.takesValue()) {
                    if (n == this.args.size() - 1) {
                        throw new IllegalArgumentException("No value for argument: " + arg.getName());
                    }
                    string3 = (String)arrayList.get(++n);
                    arg.setValue(string3);
                }
                if (this.argHook != null) {
                    this.argHook.action(string, string3);
                }
                argDecl.trigger(arg);
                this.args.add(arg);
                continue;
            }
            if (this.getIgnoreUnknown()) continue;
            throw new IllegalArgumentException("Unknown argument: " + string);
        }
        if (n < arrayList.size()) {
            if (arrayList.get(n).equals("-") || arrayList.get(n).equals("--")) {
                ++n;
            }
            while (n < arrayList.size()) {
                this.items.add(arrayList.get(n));
                ++n;
            }
        }
    }

    public boolean contains(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public boolean contains(String string) {
        return this.getArg(string) != null;
    }

    public boolean hasArg(String string) {
        return this.getArg(string) != null;
    }

    public boolean hasArg(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public Arg getArg(ArgDecl argDecl) {
        Arg arg = null;
        Iterator iterator = this.args.iterator();
        while (iterator.hasNext()) {
            Arg arg2 = (Arg)iterator.next();
            if (!argDecl.matches(arg2)) continue;
            arg = arg2;
        }
        return arg;
    }

    public Arg getArg(String string) {
        string = ArgDecl.canonicalForm(string);
        Arg arg = null;
        Iterator iterator = this.args.iterator();
        while (iterator.hasNext()) {
            Arg arg2 = (Arg)iterator.next();
            if (!arg2.getName().equals(string)) continue;
            arg = arg2;
        }
        return arg;
    }

    public String getValue(ArgDecl argDecl) {
        Arg arg = this.getArg(argDecl);
        if (arg == null) {
            return null;
        }
        if (arg.hasValue()) {
            return arg.getValue();
        }
        return null;
    }

    public String getValue(String string) {
        Arg arg = this.getArg(string);
        if (arg == null) {
            return null;
        }
        if (arg.hasValue()) {
            return arg.getValue();
        }
        return null;
    }

    public CommandLine add(String string, boolean bl) {
        return this.add(new ArgDecl(bl, string));
    }

    public CommandLine add(boolean bl, String string) {
        return this.add(new ArgDecl(bl, string));
    }

    public CommandLine add(ArgDecl argDecl) {
        Iterator iterator = argDecl.names();
        while (iterator.hasNext()) {
            this.argMap.put(iterator.next(), argDecl);
        }
        return this;
    }

    public boolean getIgnoreUnknown() {
        return this.ignoreUnknown;
    }

    public void setIgnoreUnknown(boolean bl) {
        this.ignoreUnknown = bl;
    }

    public ArgHandler trace() {
        final PrintStream printStream = System.err;
        return new ArgHandler(){

            public void action(String string, String string2) {
                if (printStream != null) {
                    printStream.println("Seen: " + string + (string2 != null ? " = " + string2 : ""));
                }
            }
        };
    }

    public static void main(String[] stringArray) {
        CommandLine commandLine = new CommandLine();
        ArgDecl argDecl = new ArgDecl(false, "-a");
        commandLine.add(argDecl);
        commandLine.setIgnoreUnknown(true);
        ArgDecl argDecl2 = new ArgDecl(true, "--file");
        commandLine.add(argDecl2);
        ArgDecl argDecl3 = new ArgDecl(false, "-v", "--verbose");
        commandLine.add(argDecl3);
        commandLine.setHook(commandLine.trace());
        String[] stringArray2 = new String[]{"-a", "--b", "--a", "--file", "value1", "--file", "value2", "--file:value3", "--v", "rest"};
        try {
            commandLine.process(stringArray2);
            System.out.println("PROCESSED");
            if (commandLine.getArg("file") == null) {
                System.out.println("No --file seen");
            } else {
                System.out.println("--file => " + commandLine.getArg(argDecl2).getValue());
            }
            if (!commandLine.hasArg(argDecl)) {
                System.out.println("No --a seen");
            } else {
                System.out.println("--a seen " + commandLine.getArg(argDecl).getValue());
            }
            System.out.println("DUMP");
            Iterator iterator = commandLine.args().iterator();
            while (iterator.hasNext()) {
                Arg arg = (Arg)iterator.next();
                String string = arg.hasValue() ? " = " + arg.getValue() : "";
                System.out.println("Arg: " + arg.getName() + string);
            }
            iterator = commandLine.items().iterator();
            while (iterator.hasNext()) {
                System.out.println("Item: " + (String)iterator.next());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Illegal argument: " + illegalArgumentException.getMessage());
        }
    }
}

